/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class ProfileDataRestore
implements HMCCommands {
    private HSCCECClient hcc = null;
    private String managedSystem;
    private String fileName;
    private short restoreType;

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        if ((this.managedSystem == null || this.fileName == null) && this.restoreType != 4) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.PROFILE_RESTORE_TYPE_PARAM + ", and " + HMCCommandUtils.FILE_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    private void validateParameterValues() throws RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (this.restoreType != 0 && this.restoreType != 1 && this.restoreType != 2 && this.restoreType != 3 && this.restoreType != 4) {
            objectArray = new String[]{"1, 2, 3, " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", objectArray) + " " + 4};
            string = "An invalid parameter value was entered. The restore type entered must be1, 2, 3, " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "or", objectArray) + " " + 4 + ". Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_RESTORE_TYPE_VALUE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.validateParameterValues();
        this.initializeClients();
        String string = "";
        if (!this.fileName.substring(0, 1).equals("/")) {
            string = this.hcc.getIntName();
            this.fileName = "/var/hsc/profiles/" + string + "/" + this.fileName;
        }
        if (this.restoreType == 4) {
            this.hcc.initializeData();
        } else {
            this.hcc.restoreProfileData(this.fileName, this.restoreType);
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Object var2_2 = null;
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.fileName = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
        String string = (String)hashMap.get(HMCCommandUtils.PROFILE_RESTORE_TYPE_PARAM);
        if (string != null) {
            this.restoreType = Short.parseShort(string);
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RESTORE_PROFILE_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        ProfileDataRestore profileDataRestore = new ProfileDataRestore();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                profileDataRestore.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    profileDataRestore.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                profileDataRestore.mapParameters(hashMap);
                profileDataRestore.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

